namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\Product;
use App\Models\User;

class ReportController extends Controller
{
    public function adminReport()
    {
        $totalRevenue = Order::sum('total_amount');
        $totalUsers = User::count();
        $totalProducts = Product::count();

        return view('admin.reports.index', compact('totalRevenue', 'totalUsers', 'totalProducts'));
    }

    public function sellerReport()
    {
        $sellerId = auth()->id();

        $totalSales = Order::whereHas('orderItems.inventoryItem.product', function ($query) use ($sellerId) {
            $query->where('seller_id', $sellerId);
        })->sum('total_amount');

        $products = Product::where('seller_id', $sellerId)->with('inventoryItems')->get();

        return view('seller.reports.index', compact('totalSales', 'products'));
    }

    public function buyerReport()
    {
        $buyerId = auth()->id();

        $orders = Order::where('user_id', $buyerId)->with('orderItems')->get();
        $totalSpent = $orders->sum('total_amount');

        return view('buyer.reports.index', compact('orders', 'totalSpent'));
    }
}